/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import java.util.function.Supplier;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.CowJarHandler;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;

public class IMCHandler {
    private final NonNullList<ItemStack> imcNonFoodRecipes = NonNullList.func_191196_a();

    private <T> T getMessageData(InterModComms.IMCMessage message) {
        Supplier supplier = message.getMessageSupplier();
        return supplier.get();
    }

    @SubscribeEvent
    public void handleIMCMessage(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            switch (message.getMethod()) {
                case "RegisterTool": {
                    ItemStack itemStack = (ItemStack)this.getMessageData((InterModComms.IMCMessage)message);
                    CookingForBlockheadsAPI.addToolItem(itemStack);
                    break;
                }
                case "RegisterWaterItem": {
                    ItemStack itemStack = (ItemStack)this.getMessageData((InterModComms.IMCMessage)message);
                    CookingForBlockheadsAPI.addWaterItem(itemStack);
                    break;
                }
                case "RegisterMilkItem": {
                    ItemStack itemStack = (ItemStack)this.getMessageData((InterModComms.IMCMessage)message);
                    CookingForBlockheadsAPI.addMilkItem(itemStack);
                    break;
                }
                case "RegisterToast": {
                    CompoundNBT tagCompound = (CompoundNBT)this.getMessageData((InterModComms.IMCMessage)message);
                    ItemStack inputItem = ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l("Input"));
                    ItemStack toastOutputItem = ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l("Output"));
                    if (!inputItem.func_190926_b() && !toastOutputItem.func_190926_b()) {
                        CookingForBlockheadsAPI.addToasterHandler(inputItem, it -> toastOutputItem);
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterToast expected message of type NBT with structure {Input : ItemStack, Output : ItemStack}");
                    break;
                }
                case "RegisterOvenFuel": {
                    CompoundNBT tagCompound = (CompoundNBT)this.getMessageData((InterModComms.IMCMessage)message);
                    ItemStack inputItem = ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l("Input"));
                    if (!inputItem.func_190926_b() && tagCompound.func_150297_b("FuelValue", 99)) {
                        CookingForBlockheadsAPI.addOvenFuel(inputItem, tagCompound.func_74762_e("FuelValue"));
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterOvenFuel expected message of type NBT with structure {Input : ItemStack, FuelValue : numeric}");
                    break;
                }
                case "RegisterOvenRecipe": {
                    CompoundNBT tagCompound = (CompoundNBT)this.getMessageData((InterModComms.IMCMessage)message);
                    ItemStack inputItem = ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l("Input"));
                    ItemStack outputItem = ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l("Output"));
                    if (!inputItem.func_190926_b() && !outputItem.func_190926_b()) {
                        CookingForBlockheadsAPI.addOvenRecipe(inputItem, outputItem);
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterOvenRecipe expected message of type NBT with structure {Input : ItemStack, Output : ItemStack}");
                    break;
                }
                case "RegisterNonFoodRecipe": {
                    ItemStack itemStack = (ItemStack)this.getMessageData((InterModComms.IMCMessage)message);
                    this.imcNonFoodRecipes.add((Object)itemStack);
                    break;
                }
                case "RegisterCowClass": {
                    String cowClassName = (String)this.getMessageData((InterModComms.IMCMessage)message);
                    try {
                        Class<?> clazz = Class.forName(cowClassName);
                        CowJarHandler.registerCowClass(clazz);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        CookingForBlockheads.logger.error("Could not register cow class " + cowClassName + ": " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void onFoodRegistryInit(FoodRegistryInitEvent event) {
        for (ItemStack itemStack : this.imcNonFoodRecipes) {
            event.registerNonFoodRecipe(itemStack);
        }
    }
}

